"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Pointing_exports = {};
__export(Pointing_exports, {
  Pointing: () => Pointing
});
module.exports = __toCommonJS(Pointing_exports);
var import_editor = require("@tldraw/editor");
class Pointing extends import_editor.StateNode {
  static id = "pointing";
  shape;
  markId = "";
  onExit = () => {
    this.editor.setHintingShapes([]);
  };
  onPointerMove = (info) => {
    if (this.editor.inputs.isDragging) {
      const {
        inputs: { originPagePoint }
      } = this.editor;
      const id = (0, import_editor.createShapeId)();
      this.markId = `creating:${id}`;
      this.editor.mark(this.markId);
      const shape = this.createTextShape(id, originPagePoint, false);
      if (!shape) {
        this.cancel();
        return;
      }
      this.shape = this.editor.getShape(shape);
      this.editor.select(id);
      this.editor.setCurrentTool("select.resizing", {
        ...info,
        target: "selection",
        handle: "right",
        isCreating: true,
        creationCursorOffset: { x: 18, y: 1 },
        onInteractionEnd: "text",
        onCreate: () => {
          this.editor.setEditingShape(shape.id);
          this.editor.setCurrentTool("select.editing_shape");
        }
      });
    }
  };
  onPointerUp = () => {
    this.complete();
  };
  onComplete = () => {
    this.cancel();
  };
  onCancel = () => {
    this.cancel();
  };
  onInterrupt = () => {
    this.cancel();
  };
  complete() {
    this.editor.mark("creating text shape");
    const id = (0, import_editor.createShapeId)();
    const { currentPagePoint } = this.editor.inputs;
    const shape = this.createTextShape(id, currentPagePoint, true);
    if (!shape) return;
    this.editor.select(id);
    this.editor.setEditingShape(id);
    this.editor.setCurrentTool("select");
    this.editor.root.getCurrent()?.transition("editing_shape");
  }
  cancel() {
    this.parent.transition("idle");
    this.editor.bailToMark(this.markId);
  }
  createTextShape(id, point, autoSize) {
    this.editor.createShape({
      id,
      type: "text",
      x: point.x,
      y: point.y,
      props: {
        text: "",
        autoSize,
        w: 20,
        scale: this.editor.user.getIsDynamicResizeMode() ? 1 / this.editor.getZoomLevel() : 1
      }
    });
    const shape = this.editor.getShape(id);
    if (!shape) {
      this.cancel();
      return;
    }
    const bounds = this.editor.getShapePageBounds(shape);
    const delta = new import_editor.Vec();
    if (autoSize) {
      switch (shape.props.textAlign) {
        case "start": {
          delta.x = 0;
          break;
        }
        case "middle": {
          delta.x = -bounds.width / 2;
          break;
        }
        case "end": {
          delta.x = -bounds.width;
          break;
        }
      }
    } else {
      delta.x = 0;
    }
    delta.y = -bounds.height / 2;
    if ((0, import_editor.isShapeId)(shape.parentId)) {
      const transform = this.editor.getShapeParentTransform(shape);
      delta.rot(-transform.rotation());
    }
    this.editor.updateShape({
      ...shape,
      x: shape.x + delta.x,
      y: shape.y + delta.y
    });
    return shape;
  }
}
//# sourceMappingURL=Pointing.js.map
